 aR  w ` mP9      h	 o_       nSystem-wide$PAGEWIDTH (150)

    NAME Intrcept_Task

; This module is a 'Stub' for linking with the
; GRiDLink and PhoneLink modules that will run
; under the MsDos operating system.

; It provides the interface to the Cp Calls


DGROUP GROUP DATA, MEMDATA
CGROUP GROUP CODE

; Valid Exported calls

    PUBLIC CpAddressOf, Upper, CompareChars
    PUBLIC OsCreateSemaphore, OsDeleteSemaphore
    PUBLIC OsWait, OsSignal, OsForkProcess
    PUBLIC IntAllocate, OsAllocate, OsFree
    PUBLIC overflowFlag1, overflowFlag2
    PUBLIC oldTimerOff, oldTimerSeg

; Stubs that are called

    PUBLIC OsWhoAmI, OsDelay
    PUBLIC OsDeleteProcess, OsSetPriority


; Stubs to check for unsupported calls

    PUBLIC OsCreateProcess
    PUBLIC IntSend, OsSend, OsReceive
    PUBLIC OsGetSize, OsGetMemStatus
    PUBLIC OsDelete, OsRename, OsAttach, OsOpen
    PUBLIC OsClose, OsDetach, OsRead, OsWrite
    PUBLIC OsSeek, OsTruncate, OsGetStatus
    PUBLIC OsSetStatus, OsChangeExtension
    PUBLIC OsFlushAllBuffers, OsOverlay
    PUBLIC OsGetArgument, OsSwitchBuffer
    PUBLIC OsRegisterName, OsDecodeException
    PUBLIC OsHandleCancel, OsGetTime
    PUBLIC OsGetSystemID, OsGetPrefix
    PUBLIC OsLookupName, OsGetWork, OsExit
    PUBLIC CpSetActiveSlot, CpGetMySlot
    PUBLIC GetConsoleState
    PUBLIC OsGetProperty, OsPutProperty
    PUBLIC OsAddDevice, OsRemoveDevice
    PUBLIC OsMatchWildcard, OsCallDriver


    EXTRN  inside:BYTE
    EXTRN  printerTimedOut:BYTE
    EXTRN  printerConn:WORD
    EXTRN  lastPrintTime:DWORD

    EXTRN  timeSlice:WORD
    EXTRN  IllegalCall:NEAR

    EXTRN  CpSetInterrupt:NEAR
$EJECT

; constants

TRUE          EQU 1
FALSE         EQU 0
NULLWORD      EQU 0FFFFH
NULLBYTE      EQU 0FFH



; interrupt ID's

int8087       EQU 0
intGpib       EQU 1
intKeyboard   EQU 2  ; (Never used on CCCOS)
intSysTick    EQU 3  ; (intVertSync on compass)
intModem      EQU 4
intBubble     EQU 5  ; (Never used on CCCOS)
intSerial     EQU 6
intRing       EQU 7

; 8-15 are mapped as logical 8-15 = physical 0-7


; multi-tasking constants

mainPid       EQU 0
forkPid       EQU 1

forkStackSize EQU 1024

initialFlags  EQU 0F246H

timedMask     EQU 0Fh
snoozeSignal  EQU 080H      ; signal, but don't reschedule

readyState    EQU 0H
semaWait      EQU 1H
timedBit      EQU 10H
timedSemaWait EQU 11H
birthState    EQU 0FFH

maxSemaphores EQU 31

semaNotExist  EQU 0
semaNotSignal EQU 1
semaSignalled EQU 2


; errors

eOK           EQU 0         ; no error
eBadPointer   EQU 31        ; error if links are bad
eInvMemBlock  EQU 11        ; invalid memory block (never allocated)
eCheckSum     EQU 29        ; checksum error
eOutOfMem     EQU 2         ; out of memory
eProcNotExist EQU 251       ; process does not exist
eSemaNotExist EQU 252       ; semaphore does not exist
eTimeOut      EQU 253       ; timed out error
eTooManyMsgs  EQU 255       ; too many messages for the queue

; multi-tasking constants

signalNormal  EQU 1         ; do a normal signal
$EJECT

; structures

MemType STRUC
    numBlks       DW ?
    nextMemBlk    DW ?
    allocated     DB ?
    memUnused1    DB ?
    memUnused2    DW ?
    memUnused3    DW ?
    memUnused4    DW ?
    memUnused5    DW ?
    memUnused6    DW ?
MemType ENDS

QcbType STRUC
    headOfQ       DW ?
    tailOfQ       DW ?
    usesChecksum  DB ?
    qcbCount      DW ?
    elementLength DW ?
QcbType ENDS

ForkStackType STRUC
    fsStack       DB forkStackSize DUP (?)
    fsRetIP       DW ?
    fsStartIP     DW ?
    fsStartCS     DW ?
    fsStartFlags  DW ?
ForkStackType ENDS

PcbType STRUC
    pcbState      DB ?
    pcbTimeLimit  DW ?
    pcbNote       DW ?
    pcbSource     DW ?
    pcbStackOff   DW ?
    pcbStackSeg   DW ?
    pcbPErrorOff  DW ?
    pcbPErrorSeg  DW ?
PcbType ENDS
$EJECT

DATA SEGMENT PUBLIC 'DATA'

dummyX        DB ?          ; to force word alignment of sema notes

osProcessQ    QcbType <>    ; Q of all processes
osSemaQ       QcbType <>    ; Q of all semaphores
currentPid    DW mainPid    ; the currentPid
loopPid       DW ?          ; temporary process that just loops
bootTrace     DB ?          ; character of boot device
pBusyStack    DD ?          ; address of busy stack start
sysCounter    DD ?          ; system counter
timedProcs    DW ?          ; # processes waiting on time
gpibJump      DB ?          ; long jump instr.
pGPiBRoutine  DD ?          ; offset of current gpib driver
pFontTable    DD ?          ; pointer to font table
nextRunPID    DW mainPid    ; used by rescheduler
dummy         DW ?          ; used by mem manager

; First semaphore is for memory manager

semaTable     DB semaSignalled
              DB maxSemaphores DUP (0)
semaNotes     DW ?
              DW maxSemaphores DUP (?)

overFlowFlag1 DW 0
              DW 62 DUP (?)
topTimerStk1  DW ?

overFlowFlag2 DW 0
              DW 62 DUP (?)
topTimerStk2  DW ?

fStack        ForkStackType <>

mainPcb       PcbType <readyState, 0, 0, 0, 0, 0, 0, 0>
forkPcb       PcbType <birthState, 0, 0, 0, 0, 0, 0, 0>

              ORG OFFSET (mainPcb)

pcbs          PcbType <>
              PcbType <>

DATA ENDS

;------------------------------------------------

MEMDATA SEGMENT PUBLIC 'DATA'

numMemBlks    EQU 639            ; 10K Memory Pool

firstMemBlk   MemType <numMemBlks, 0, 0, 0, 0, 0, 0, 0, 0>
otherMemBlks  MemType numMemBlks DUP (<>)

MEMDATA ENDS
$EJECT

CODE SEGMENT PUBLIC 'CODE'
     ASSUME CS:CGROUP, DS:DGROUP

overFlowFlag0    DW 0
                 DW 62 DUP (?)
topTimerStk0     DW ?

oldTimerOff      DW ?
oldTimerSeg      DW ?

userStackSS0     DW ?
userStackSP0     DW ?

userStackSS1     DW ?
userStackSP1     DW ?

userStackSS2     DW ?
userStackSP2     DW ?

inTimerIntrCall  DB FALSE
inTimerInterrupt DB FALSE
cpmPrnTimedOut   DB FALSE
$EJECT

;  Upper: PROCEDURE (char) BYTE CLEAN;
;    DCL char BYTE;
;
;    This will return the upper case value of a letter.

char EQU BYTE PTR [BP+4]

Upper PROC NEAR
    PUSH BP
    MOV  BP, SP

    MOV  AL, char
    CMP  AL, 'a'
    JB   UpperExit
    CMP  AL, 'z'
    JA   UpperExit
    AND  AL, 0DFH

UpperExit:
    POP  BP
    RET  2
Upper ENDP

PURGE char
$EJECT

;  CompareChars: PROCEDURE (pString1, pString2, length) BOOLEAN CLEAN;
;    DCL lenCompare WORD;
;    DCL pString1   PTR;
;    DCL pString2   PTR;
;
;    This will return TRUE if two buffers are equal.  Case is ignored.
;
;    NOTE: This routine depends on the routine
;      Upper only changing register AL.

lenCompare EQU WORD  PTR [BP+6]
pString2   EQU DWORD PTR [BP+8]
pString1   EQU DWORD PTR [BP+12]

CompareChars PROC NEAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    MOV  CX, lenCompare
    JCXZ CompareEqual

    LDS  SI, pString1
    LES  DI, pString2

CompareTopOfLoop:
    MOV  AL, DS:[SI]      ; get the Upper of the
    PUSH AX
    CALL Upper            ; byte at string1 (next)
    MOV  BL, AL           ; save this Upper value

    MOV  AL, ES:[DI]      ; get the Upper of the
    PUSH AX
    CALL Upper            ; byte at string2 (next)

    CMP  AL, BL           ; if the characters
    MOV  AL, false        ; do not match, then
    JNZ  CompareExit      ; RETURN (FALSE)

    INC  SI               ; point to next str1 char
    INC  DI               ; point to next str2 char
    LOOP CompareTopOfLoop ; keep checking

CompareEqual:
    MOV  AL, true         ; RETURN (TRUE);

CompareExit:
    POP  BP
    POP  DS
    RET  10
CompareChars ENDP

PURGE lenCompare, pString2, pString1
$EJECT

;    CpAddressOf: PROCEDURE PTR CLEAN;
;
;    This will return the start of the block
;    of variables of the prom

CpAddressOf PROC NEAR

    MOV  AX, SEG    DGROUP:osProcessQ  ; osProcess Q is the
    MOV  ES, AX                        ; first variable of
    MOV  BX, OFFSET DGROUP:osProcessQ  ; the PROM variables

    RET
CpAddressOf ENDP



;    PopStart
;
;    This routine is the method used to start
;    off a new process.  It will work for forked
;    processes only.

PopStart PROC FAR

    IRET
PopStart ENDP
$EJECT

;
;    OsWhoAmI: PROCEDURE WORD CLEAN;
;

OsWhoAmI PROC
    RET
OsWhoAmI ENDP


;
;    OsDelay: PROCEDURE (time) CLEAN;
;

OsDelay PROC
    RET  2
OsDelay ENDP


;
;    OsDeleteProcess: PROCEDURE (pid, pError) CLEAN;
;

pError      EQU DWORD PTR [BP+4]
pid         EQU WORD  PTR [BP+8]

OsDeleteProcess PROC
    PUSH BP
    MOV  BP, SP

    LES  BX, pError
    MOV  WORD PTR ES:[BX], 0

    POP  BP
    RET  6
OsDeleteProcess ENDP

PURGE pError, pid


;
;    OsSetPriority: PROCEDURE (pid, priority, pError) CLEAN;
;

pError      EQU DWORD PTR [BP+4]
priority    EQU BYTE  PTR [BP+8]
pid         EQU WORD  PTR [BP+10]

OsSetPriority PROC
    PUSH BP
    MOV  BP, SP

    LES  BX, pError
    MOV  WORD PTR ES:[BX], 0

    POP  BP
    RET  8
OsSetPriority ENDP

PURGE pError, priority, pid
$EJECT

;    OsForkProcess: PROCEDURE (ePoint, pri, uses8087, stackSize, pError) WORD CLEAN;
;
;    This is a subset of the real OsForkProcess
;    found in GRiD-Os.  It assumes that only one
;    process can be forked.  Memory for the stack
;    is static.

pError      EQU DWORD PTR [BP+4]
stackSize   EQU WORD  PTR [BP+8]
uses8087    EQU BYTE  PTR [BP+10]
pri         EQU BYTE  PTR [BP+12]
ePoint      EQU DWORD PTR [BP+14]

OsForkProcess PROC NEAR
    PUSH BP
    MOV  BP, SP
    PUSH DS
    PUSHF
    CLI

    LES  AX, ePoint
    MOV  fStack.fsStartFlags, initialFlags
    MOV  fStack.fsStartCS, ES
    MOV  fStack.fsStartIP, AX
    MOV  fStack.fsRetIP, OFFSET PopStart

    MOV  AX, OFFSET fStack.fsRetIP
    MOV  forkPcb.pcbStackSeg, DS
    MOV  forkPcb.pcbStackOff, AX

    XOR  AX, AX                     ; error / ready
    MOV  forkPcb.pcbState, AL
    LDS  SI, pError
    MOV  DS:[SI], AX

    MOV  AX, intSysTick
    PUSH AX
    MOV  AX, SEG    CGROUP:TimerInt
    PUSH AX
    MOV  AX, OFFSET CGROUP:TimerInt
    PUSH AX
    CALL CpSetInterrupt

    MOV  CS:oldTimerOff, BX
    MOV  CS:oldTimerSeg, ES

    POPF
    POP  DS
    POP  BP
    RET  14
OsForkProcess ENDP

PURGE pError, stackSize, uses8087, pri, ePoint
$EJECT

;    TimerInt
;

TimerInt PROC FAR
    TEST CS:inTimerIntrCall, TRUE
    JZ   TimerIntCallHere

    JMP  DWORD PTR CS:oldTimerOff

TimerIntCallHere:
    MOV  CS:inTimerIntrCall, TRUE
    MOV  CS:userStackSS0, SS
    MOV  CS:userStackSP0, SP
    MOV  SP, SEG    CGROUP:topTimerStk0
    MOV  SS, SP
    MOV  SP, OFFSET CGROUP:topTimerStk0

    PUSHF                           ; Make this look like an interrupt
    CALL DWORD PTR CS:oldTimerOff

    CLI
    MOV  SS, CS:userStackSS0
    MOV  SP, CS:userStackSP0
    MOV  CS:inTimerIntrCall, FALSE

    TEST CS:inTimerInterrupt, TRUE
    JNZ  TimerIntSaveOnStack2

TimerIntSaveOnStack1:
    MOV  CS:userStackSS1, SS
    MOV  CS:userStackSP1, SP
    MOV  SP, SEG    DGROUP:topTimerStk1
    MOV  SS, SP
    MOV  SP, OFFSET DGROUP:topTimerStk1
    JMP  SHORT TimerIntSaveRegs

TimerIntSaveOnStack2:
    MOV  CS:userStackSS2, SS
    MOV  CS:userStackSP2, SP
    MOV  SP, SEG    DGROUP:topTimerStk2
    MOV  SS, SP
    MOV  SP, OFFSET DGROUP:topTimerStk2

TimerIntSaveRegs:
    PUSH ES
    PUSH DS
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH DI
    PUSH SI
    PUSH BP

    MOV  AX, SEG DGROUP:mainPcb
    MOV  DS, AX

    MOV  AX, DS:timeSlice
    ADD  WORD PTR sysCounter+0, AX
    ADC  WORD PTR sysCounter+2, 0

TimerIntIsMainReady:
    TEST mainPcb.pcbState, timedBit
    JZ   TimerIntIsForkReady

    MOV  AX, mainPcb.pcbTimeLimit
    OR   AX, AX
    JZ   TimerIntMainIsReady

    DEC  AX
    MOV  mainPcb.pcbTimeLimit, AX
    JMP  SHORT TimerIntIsForkReady

TimerIntMainIsReady:
    MOV  ES, mainPcb.pcbPErrorSeg
    MOV  BX, mainPcb.pcbPErrorOff
    MOV  WORD PTR ES:[BX], eTimeOut
    MOV  mainPcb.pcbState, AL       ; AL = readyState (0)

TimerIntIsForkReady:
    MOV  AL, forkPcb.pcbState
    TEST AL, timedBit
    JZ   TimerIntReschForkNow

    MOV  AX, forkPcb.pcbTimeLimit
    OR   AX, AX
    JZ   TimerIntForkIsReady

    DEC  AX
    MOV  forkPcb.pcbTimeLimit, AX
    JMP  SHORT TimerIntCheckPrinterTimeOut

TimerIntForkIsReady:
    MOV  ES, forkPcb.pcbPErrorSeg
    MOV  BX, forkPcb.pcbPErrorOff
    MOV  WORD PTR ES:[BX], eTimeOut
    MOV  forkPcb.pcbState, AL       ; AL = readyState (0)

TimerIntReschForkNow:
    OR   AL, AL                     ; AL = ready? (0)
    JNZ  TimerIntCheckPrinterTimeOut

    TEST CS:inTimerInterrupt, TRUE
    JNZ  TimerIntRestoreRegs

    MOV  CS:inTimerInterrupt, TRUE
    CALL Reschedule
    MOV  CS:inTimerInterrupt, FALSE

TimerIntCheckPrinterTimeOut:
    CMP  DS:printerConn, NULLWORD
    JE   TimerIntRestoreRegs

    TEST CS:inside, TRUE
    JNZ  TimerIntRestoreRegs

    CMP  currentPid, mainPid
    JNE  TimerIntRestoreRegs

    LES  AX, sysCounter
    MOV  DX, ES
    SUB  AX, WORD PTR DS:lastPrintTime
    SBB  DX, WORD PTR DS:lastPrintTime + 2
    OR   DX, DX
    JNZ  TimerIntPrinterTimedOut

    CMP  AX, 30000                  ; 30 secs for printer timeout
    JB   TimerIntRestoreRegs

TimerIntPrinterTimedOut:
    MOV  CS:cpmPrnTimedOut, TRUE
    MOV  DS:printerTimedOut, TRUE

TimerIntRestoreRegs:
    POP  BP
    POP  SI
    POP  DI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POP  DS
    POP  ES

    TEST CS:inTimerInterrupt, TRUE
    JNZ  TimerIntRestoreFromStack2

TimerIntRestoreFromStack1:
    MOV  SS, CS:userStackSS1
    MOV  SP, CS:userStackSP1
    JMP  SHORT TimerIntExitCheckPrnTimeOut

TimerIntRestoreFromStack2:
    MOV  SS, CS:userStackSS2
    MOV  SP, CS:userStackSP2

TimerIntExitCheckPrnTimeOut:
    TEST CS:cpmPrnTimedOut, TRUE
    JZ   TimerIntExit

    MOV  CS:cpmPrnTimedOut, FALSE
    PUSH AX
    MOV  AX, 0CFFH                  ; Flush Kbd
    INT  21H
    POP  AX

TimerIntExit:
    IRET
TimerInt ENDP
$EJECT

;
;    OsWait: PROCEDURE (sid, timeLimit, pError) WORD CLEAN;
;

pError      EQU DWORD PTR [BP+4]
timeLimit   EQU WORD  PTR [BP+8]
sid         EQU WORD  PTR [BP+10]

OsWait PROC NEAR
    PUSH BP
    MOV  BP, SP
    PUSHF
    CLI

    PUSH sid
    CALL SemaphoreExists
    OR   AX, AX

    LES  DI, pError
    JNZ  OsWaitErrorExit

    MOV  ES:[DI], AX
    CMP  semaTable [BX], semaSignalled
    JNZ  OsWaitNotSignalled

OsWaitSignalled:
    MOV  semaTable [BX], semaNotSignal
    SHL  BX, 1
    MOV  AX, semaNotes [BX]
    JMP  SHORT OsWaitExit

OsWaitNotSignalled:
    CMP  timeLimit, AX              ; AX = 0
    MOV  AX, eTimeOut
    JE   OsWaitErrorExit

OsWaitReschedule:
    MOV  AX, currentPid
    MOV  CX, SIZE mainPcb
    MUL  CX
    MOV  SI, AX

    MOV  CL, semaWait
    MOV  AX, timeLimit
    CMP  AX, NULLWORD
    JE   OsWaitNotTimed

OsWaitTimed:
    OR   CL, timedBit
    PUSH CX
    MOV  CX, DS:timeSlice
    ADD  AX, CX
    SUB  DX, DX
    DIV  CX
    MOV  pcbs[SI].pcbTimeLimit, AX
    POP  CX

OsWaitNotTimed:
    MOV  pcbs[SI].pcbState, CL
    MOV  pcbs[SI].pcbSource, BX
    MOV  pcbs[SI].pcbPErrorSeg, ES
    MOV  pcbs[SI].pcbPErrorOff, DI

    PUSH SI
    CALL Reschedule
    POP  SI

    MOV  AX, pcbs[SI].pcbNote
    JMP  SHORT OsWaitExit

OsWaitErrorExit:
    MOV  ES:[DI], AX
    MOV  AX, NULLWORD

OsWaitExit:
    POPF
    POP  BP
    RET  8
OsWait ENDP

PURGE pError, timeLimit, sid
$EJECT

;
;    OsSignal: PROCEDURE (sid, mode, note, pError) CLEAN;
;

pError      EQU DWORD PTR [BP+4]
note        EQU WORD  PTR [BP+8]
mode        EQU WORD  PTR [BP+10]
sid         EQU WORD  PTR [BP+12]

OsSignal PROC NEAR
    PUSH BP
    MOV  BP, SP
    PUSHF
    CLI

    PUSH sid
    CALL SemaphoreExists
    OR   AX, AX
    JNZ  OsSignalErrorExit

    MOV  SI, SIZE mainPcb           ; first ckh fork
    MOV  CX, 2                      ; check both
    MOV  DX, note                   ; DX = note

OsSignalCheckWaiter:
    MOV  AL, pcbs[SI].pcbState
    AND  AL, 0FH
    CMP  AL, semaWait
    JNE  OsSignalCheckNextWaiter

    CMP  BX, pcbs[SI].pcbSource
    JNE  OsSignalCheckNextWaiter

OsSignalWaiterFound:
    MOV  pcbs[SI].pcbNote, DX
    MOV  pcbs[SI].pcbState, CH      ; CH = readyState (0)
    JMP  SHORT OsSignalExit

OsSignalCheckNextWaiter:
    SUB  SI, SI                     ; now chk main
    LOOP OsSignalCheckWaiter

OsSignalNoWaiter:
    MOV  semaTable[BX], semaSignalled
    SHL  BX, 1
    MOV  semaNotes[BX], DX

OsSignalExit:
    SUB  AX, AX                     ; error = eOK

OsSignalErrorExit:
    LES  DI, pError
    MOV  ES:[DI], AX

    POPF
    POP  BP
    RET  10
OsSignal ENDP

PURGE pError, note, mode, sid
$EJECT

;
;    Reschedule: PROCEDURE CLEAN;
;

Reschedule PROC NEAR
    PUSHF
    STI                             ; ENABLE

    XOR  AX, AX                     ; AX = mainPid
                                    ; AH = readyState
RescheduleFindReadyProcess:
    INC  AX
    CMP  forkPcb.pcbState, AH
    JE   RescheduleProcessReady

    DEC  AX
    CMP  mainPcb.pcbState, AH
    JNE  RescheduleFindReadyProcess

RescheduleProcessReady:
    CLI                             ; DISABLE

    CMP  AX, currentPid
    JE   RescheduleExit

    MOV  nextRunPid, AX
    CALL SwapTasksRoutine

RescheduleExit:
    POPF
    RET
Reschedule ENDP
$EJECT

;
;    SwapTasksRoutine: PROCEDURE CLEAN;
;

SwapTasksRoutine PROC NEAR
    MOV  AX, currentPid
    MOV  CX, SIZE mainPcb
    MUL  CX
    MOV  BX, AX
    MOV  pcbs[BX].pcbStackSeg, SS
    MOV  pcbs[BX].pcbStackOff, SP

    MOV  AX, nextRunPid
    MOV  currentPid, AX

    MUL  CX
    MOV  BX, AX
    MOV  SS, pcbs[BX].pcbStackSeg
    MOV  SP, pcbs[BX].pcbStackOff
    RET
SwapTasksRoutine ENDP
$EJECT

;
;    OsCreateSemaphore: PROCEDURE (pError) WORD CLEAN;
;

pError      EQU DWORD PTR [BP+4]

OsCreateSemaphore PROC NEAR
    PUSH BP
    MOV  BP, SP
    PUSHF
    CLI

    XOR  BX, BX                     ; index = 0
    MOV  CX, maxSemaphores          ; max

OsCreateSemaSearch:
    CMP  semaTable[BX], semaNotExist
    JE   OsCreateSemaFound
    INC  BX
    LOOP OsCreateSemaSearch

OsCreateSemaNotFound:
    MOV  DX, eOutOfMem              ; error = eOutOfMem
    JMP  SHORT OsCreateSemaExit

OsCreateSemaFound:
    MOV  semaTable[BX], semaNotSignal
    MOV  AX, BX
    XOR  DX, DX                     ; error = eOK

OsCreateSemaExit:
    LES  DI, pError
    MOV  ES:[DI], DX

    POPF
    POP  BP
    RET  4
OsCreateSemaphore ENDP

PURGE pError
$EJECT

;
;    OsDeleteSemaphore: PROCEDURE (sid, pError) WORD CLEAN;
;

pError      EQU DWORD PTR [BP+4]
sid         EQU WORD  PTR [BP+8]

OsDeleteSemaphore PROC NEAR
    PUSH BP
    MOV  BP, SP
    PUSHF
    CLI

    PUSH sid
    CALL SemaphoreExists
    OR   AX, AX
    JNZ  OsDeleteSemaExit

    MOV  semaTable[BX], AL

OsDeleteSemaExit:
    LES  DI, pError
    MOV  ES:[DI], AX

    POPF
    POP  BP
    RET  6
OsDeleteSemaphore ENDP

PURGE pError, sid
$EJECT

;
;    SemaphoreExists: PROCEDURE (sid) WORD CLEAN;
;
;    NOTE: This routine does not conform to PLM
;    standards in that it returns information in
;    both registers AX and BX.  AX is the error 
;    code and BX is the semaphore ID.
;

sid         EQU WORD  PTR [BP+4]

SemaphoreExists PROC NEAR
    PUSH BP
    MOV  BP, SP

    MOV  AX, eSemaNotExist

    MOV  BX, sid
    CMP  BX, maxSemaphores
    JNB  SemaphoreExistsExit

    CMP  semaTable[BX], semaNotExist
    JE   SemaphoreExistsExit

    SUB  AX, AX                     ; error = eOK (0)

SemaphoreExistsExit:
    POP  BP
    RET  2
SemaphoreExists ENDP

PURGE sid
$EJECT

pError      EQU DWORD PTR [BP+4]
memSize     EQU WORD  PTR [BP+8]

IntAllocate LABEL NEAR
    POP  DI                         ; short return addr
    POP  ES
    POP  BX                         ; pError
    POP  AX                         ; memSize
    POP  CX                         ; throw away pid

    PUSH AX                         ; memSize
    PUSH BX
    PUSH ES                         ; pError
    PUSH DI                         ; short return addr

OsAllocate  PROC NEAR
    PUSH BP
    MOV  BP, SP
    PUSH DS
                                    ; Caution: DS must
    CALL EnterMemMgr                ; point to data seg
                                    ; for EnterMemMgr
    MOV  AX, memSize
    DEC  AX
    MOV  CL, 4
    SHR  AX, CL
    INC  AX                         ; # blocks needed
    XCHG AX, CX                     ; are stored in CX

    MOV  BX, SEG firstMemBlk        ; top of chain

OsAllocateFindBlock:
    OR   BX, BX                     ; if at end of chain
    JZ   OsAllocateErrorExit        ; then exit

    XCHG AX, BX                     ; curr = next
    MOV  DS, AX                     ; point to curr
    INC  AX                         ; point to users part
    MOV  BX, DS:nextMemBlk          ; save ptr to next
    TEST DS:allocated, TRUE         ; if already allocated
    JNZ  OsAllocateFindBlock        ; keep looking

    MOV  DX, DS:numBlks             ; if number of blocks
    CMP  DX, CX                     ; here are < # needed
    JL   OsAllocateFindBlock        ; keep looking

OsAllocateBlockFound:
    MOV  DS:allocated, TRUE         ; set to allocated
    PUSH AX                         ; save pointer to users part
    JE   OsAllocateOkExit           ; exit

    MOV  DS:numBlks, CX             ; new size of block
    ADD  AX, CX                     ; new header
    MOV  DS:nextMemBlk, AX          ; new ptr to next

    MOV  DS, AX                     ; point to new next
    MOV  DS:allocated, FALSE        ; maintain its freedom
    MOV  DS:nextMemBlk, BX          ; point to prev's next
    SUB  DX, CX                     ; figure # blocks left
    DEC  DX                         ; dont count header
    MOV  DS:numBlks, DX             ; save numBlks

OsAllocateOkExit:
    POP  ES                         ; ptr to block
    XOR  AX, AX                     ; error = eOK
    MOV  BX, AX                     ; offset = 0
    JMP  SHORT OsAllocateExit

OsAllocateErrorExit:
    DEC  BX
    PUSH BX
    POP  ES
    MOV  BX, 0FH                    ; Return (NULLPTR)
    MOV  AX, eOutOfMem              ; error = out of memory

OsAllocateExit:
    LDS  DI, pError                 ; DS:DI => error
    MOV  DS:[DI], AX                ; set error

    POP  DS                         ; Restore DS
                                    ; for LeaveMemMgr
    PUSH ES
    PUSH BX                         ; Save ^mem block
    CALL LeaveMemMgr
    POP  BX
    POP  ES                         ; Restore ^mem block

    POP  BP
    RET  6
OsAllocate  ENDP

PURGE memSize, pError
$EJECT

pError      EQU DWORD PTR [BP+4]
pBlockOff   EQU WORD  PTR [BP+8]
pBlockSeg   EQU WORD  PTR [BP+10]

OsFree PROC NEAR
    PUSH BP
    MOV  BP, SP
    PUSH DS                         ; Caution: DS must
                                    ; point to data seg
    CALL EnterMemMgr                ; for EnterMemMgr

    MOV  DX, eInvMemBlock           ; error = invalid block
    MOV  AX, pBlockOff              ; if memory block
    OR   AX, AX                     ; is not on a SEG boundary
    JNZ  OsFreeExit                 ; then error
    
    MOV  CX, pBlockSeg              ; block to be freed
    DEC  CX                         ; point to mem header
    MOV  BX, AX                     ; prev = 0
    MOV  AX, SEG firstMemBlk        ; top of chain

OsFreeFindBlock:
    CMP  AX, CX                     ; if this is the block
    MOV  DS, AX
    JE   OsFreeBlockFound           ; remove it

    MOV  BX, AX                     ; prev = curr
    MOV  AX, DS:nextMemBlk          ; curr = curr.next
    OR   AX, AX                     ; if at the end
    JZ   OsFreeExit                 ; block not found, error
    JMP  OsFreeFindBlock            ; keep looking

OsFreeBlockFound:
    TEST DS:allocated, TRUE         ; if this block is already free
    JZ   OsFreeExit                 ; then error

    XOR  DX, DX                     ; error = eOK
    MOV  DS:allocated, DL           ; allocated = FALSE
    CALL CombineWithNextBlock
    MOV  AX, BX                     ; curr = prev
    OR   AX, AX                     ; if at top of chain
    JZ   OsFreeExit                 ; exit

    MOV  DS, AX
    CMP  DS:allocated, DL           ; if not allocated
    JNE  OsFreeExit                 ; exit

    CALL CombineWithNextBlock

OsFreeExit:
    LDS  BX, pError                 ; DS:BX => error
    MOV  DS:[BX], DX                ; error = ???

    POP  DS                         ; Restore DS
                                    ; for LeaveMemMgr
    CALL LeaveMemMgr

    POP  BP
    RET  8
OsFree ENDP

PURGE pBlockSeg, pBlockOff, pError
$EJECT

;      This routine will combine the current free
;      block (pointed to by DS) with the next
;      block in the chain, if it is free

CombineWithNextBlock PROC NEAR
    MOV  AX, DS:nextMemBlk          ; if at the end
    OR   AX, AX                     ; of the chain
    JZ   CombineBlocksExit          ; then exit

    MOV  ES, AX                     ; if next block
    TEST ES:allocated, TRUE         ; is allocated
    JNZ  CombineBlocksExit          ; then exit

    MOV  AX, ES:numBlks             ; add in size of
    INC  AX                         ; next blk plus
    ADD  DS:numBlks, AX             ; size of header

    MOV  AX, ES:nextMemBlk          ; point this block
    MOV  DS:nextMemBlk, AX          ; to next's next

CombineBlocksExit:
    RET
CombineWithNextBlock ENDP



; note = OsWait (memMgrSema, forever, @dummy)

EnterMemMgr PROC
    XOR  AX, AX
    PUSH AX                         ; memMgrSema (0)
    DEC  AX
    PUSH AX                         ; forever (FFFF)
    PUSH DS
    MOV  AX, OFFSET dummy
    PUSH AX                         ; @dummy
    CALL OsWait
    RET
EnterMemMgr ENDP



; CALL OsSignal (memMgrSema, normal, xyz, @dummy)

LeaveMemMgr PROC
    XOR  AX, AX
    PUSH AX                         ; memMgrSema (0)
    INC  AX
    PUSH AX                         ; signal normal (1)
    PUSH AX                         ; any note
    PUSH DS
    MOV  AX, OFFSET dummy
    PUSH AX                         ; @dummy
    CALL OsSignal
    RET
LeaveMemMgr ENDP
$EJECT

;
;    Illegal Calls Are All Trapped Here
;

OsLookupName       LABEL NEAR
OsGetWork          LABEL NEAR
OsExit             LABEL NEAR
OsCreateProcess    LABEL NEAR
IntSend            LABEL NEAR
OsSend             LABEL NEAR
OsReceive          LABEL NEAR
OsGetSize          LABEL NEAR
OsGetMemStatus     LABEL NEAR
OsDelete           LABEL NEAR
OsRename           LABEL NEAR
OsAttach           LABEL NEAR
OsOpen             LABEL NEAR
OsClose            LABEL NEAR
OsDetach           LABEL NEAR
OsRead             LABEL NEAR
OsWrite            LABEL NEAR
OsSeek             LABEL NEAR
OsTruncate         LABEL NEAR
OsGetStatus        LABEL NEAR
OsSetStatus        LABEL NEAR
OsChangeExtension  LABEL NEAR
OsFlushAllBuffers  LABEL NEAR
OsOverlay          LABEL NEAR
OsGetArgument      LABEL NEAR
OsSwitchBuffer     LABEL NEAR
OsRegisterName     LABEL NEAR
OsDecodeException  LABEL NEAR
OsHandleCancel     LABEL NEAR
OsGetTime          LABEL NEAR
OsGetSystemID      LABEL NEAR
OsGetPrefix        LABEL NEAR
CpSetActiveSlot    LABEL NEAR
CpGetMySlot        LABEL NEAR
OsGetProperty      LABEL NEAR
OsPutProperty      LABEL NEAR
OsAddDevice        LABEL NEAR
OsRemoveDevice     LABEL NEAR
OsMatchWildcard    LABEL NEAR
OsCallDriver       LABEL NEAR
GetConsoleState    LABEL NEAR

IllegalCalls PROC NEAR
$LIST
    CALL IllegalCall

IllegalCalls ENDP

CODE ENDS

    END
